import os
import random
import sys

import cv2
import lmdb
import numpy as np
import torch
import torch.utils.data as data

import pandas as pd
from sklearn.preprocessing import StandardScaler


class Dataset_Custom(data.Dataset):

    def __init__(self, stage,seq_len=336,pred_len=96,data_paths=None):
        super().__init__()
        self.opt = stage
        self.data_paths = data_paths
        self.seq_len, self.pred_len = seq_len,pred_len  
        self.scale = True
        self.train_only=False
        
        self.type_map = {'train': 0, 'val': 1, 'test': 2}
        self.__read_data__()
        


    def __read_data__(self):
        self.scaler = StandardScaler()
        df_raw = pd.read_csv(self.data_paths)
        self.flag = self.opt
        assert self.flag in ['train', 'test', 'val']
        self.set_type = self.type_map[self.flag]


        '''
        df_raw.columns: ['date', ...(other features), target feature]
        '''
        cols = list(df_raw.columns)
        cols.remove('date')

        num_train = int(len(df_raw) * (0.7 if not self.train_only else 1))
        num_test = int(len(df_raw) * 0.2)
        num_vali = len(df_raw) - num_train - num_test
        border1s = [0, num_train - self.seq_len, len(df_raw) - num_test - self.seq_len]
        border2s = [num_train, num_train + num_vali, len(df_raw)]
        border1 = border1s[self.set_type]
        border2 = border2s[self.set_type]

        
        df_raw = df_raw[['date'] + cols]
        cols_data = df_raw.columns[1:]
        df_data = df_raw[cols_data]

        if self.scale:
            train_data = df_data[border1s[0]:border2s[0]]

            self.scaler.fit(train_data.values)
            data = self.scaler.transform(df_data.values)
        else:
            data = df_data.values

        self.data_x = data[border1:border2]
        self.data_y = data[border1:border2]




    def __getitem__(self, index):
        s_begin = index
        s_end = s_begin + self.seq_len
        r_begin = s_end 
        r_end = r_begin  + self.pred_len

        seq_x = self.data_x[s_begin:s_end]
        seq_y = self.data_y[r_begin:r_end]
        seq_x = torch.from_numpy(np.ascontiguousarray(seq_x)).type(torch.FloatTensor)
        seq_y = torch.from_numpy(np.ascontiguousarray(seq_y)).type(torch.FloatTensor)

        return  seq_y, seq_x

    def __len__(self):
        return len(self.data_x) - self.seq_len - self.pred_len + 1

    def inverse_transform(self, data):
        return self.scaler.inverse_transform(data)




class Dataset_ETT_hour(data.Dataset):
    def __init__(self, stage,seq_len=336,label_len=48,pred_len=96,data_paths=None):
        super().__init__()
        self.opt = stage
        self.data_paths = data_paths
        self.seq_len, self.pred_len = seq_len,pred_len
        self.label_len = label_len
        self.scale = True
        self.train_only=False
        
        self.type_map = {'train': 0, 'val': 1, 'test': 2}
        self.__read_data__()


    def __read_data__(self):
        self.scaler = StandardScaler()
        df_raw = pd.read_csv(self.data_paths)
        self.flag = self.opt
        assert self.flag in ['train', 'test', 'val']
        self.set_type = self.type_map[self.flag]
       

        '''
        df_raw.columns: ['date', ...(other features), target feature]
        '''
        cols = list(df_raw.columns)
        cols.remove('date')
        # print(cols)
        #print("************** cols  is ****** ",cols)
        border1s = [0, 12 * 30 * 24 - self.seq_len, 12 * 30 * 24 + 4 * 30 * 24 - self.seq_len]
        border2s = [12 * 30 * 24, 12 * 30 * 24 + 4 * 30 * 24, 12 * 30 * 24 + 8 * 30 * 24]
        border1 = border1s[self.set_type]
        border2 = border2s[self.set_type]

        
        #df_raw = df_raw[['date'] + cols]
        cols_data = df_raw.columns[1:]
        df_data = df_raw[cols_data]

        if self.scale:
            train_data = df_data[border1s[0]:border2s[0]]
            #print("************** train_data  shape is ****** ",train_data.shape)
            self.scaler.fit(train_data.values)
            # print(self.scaler.mean_)
            # exit()
            data = self.scaler.transform(df_data.values)
        else:
            data = df_data.values

        self.data_x = data[border1:border2]
        self.data_y = data[border1:border2]




    def __getitem__(self, index):
        s_begin = index
        s_end = s_begin + self.seq_len
        r_begin = s_end - self.label_len
        r_end = r_begin  + self.label_len + self.pred_len 

        seq_x = self.data_x[s_begin:s_end]
        seq_y = self.data_y[r_begin:r_end]
        seq_x = torch.from_numpy(np.ascontiguousarray(seq_x)).type(torch.FloatTensor)
        seq_y = torch.from_numpy(np.ascontiguousarray(seq_y)).type(torch.FloatTensor)

        return  seq_y, seq_x

    def __len__(self):
        return len(self.data_x) - self.seq_len - self.pred_len + 1

    def inverse_transform(self, data):
        return self.scaler.inverse_transform(data)






class Dataset_ETT_minute(data.Dataset):
    def __init__(self, stage,seq_len=336,label_len=48,pred_len=96,data_paths=None):
        super().__init__()
        self.opt = stage
        self.data_paths = data_paths
        self.seq_len, self.pred_len = seq_len,pred_len 
        self.label_len = label_len
        self.scale = True
        self.train_only=False
        
        self.type_map = {'train': 0, 'val': 1, 'test': 2}
        self.__read_data__()


    def __read_data__(self):
        self.scaler = StandardScaler()
        df_raw = pd.read_csv(self.data_paths)
        self.flag = self.opt
        assert self.flag in ['train', 'test', 'val']
        self.set_type = self.type_map[self.flag]

        '''
        df_raw.columns: ['date', ...(other features), target feature]
        '''
        cols = list(df_raw.columns)
        cols.remove('date')

        border1s = [0, 12 * 30 * 24 * 4 - self.seq_len, 12 * 30 * 24 * 4 + 4 * 30 * 24 * 4 - self.seq_len]
        border2s = [12 * 30 * 24 * 4, 12 * 30 * 24 * 4 + 4 * 30 * 24 * 4, 12 * 30 * 24 * 4 + 8 * 30 * 24 * 4]        
        border1 = border1s[self.set_type]
        border2 = border2s[self.set_type]

        
        #df_raw = df_raw[['date'] + cols]
        cols_data = df_raw.columns[1:]
        df_data = df_raw[cols_data]

        if self.scale:
            train_data = df_data[border1s[0]:border2s[0]]
            self.scaler.fit(train_data.values)
            data = self.scaler.transform(df_data.values)
        else:
            data = df_data.values

        self.data_x = data[border1:border2]
        self.data_y = data[border1:border2]




    def __getitem__(self, index):
        s_begin = index
        s_end = s_begin + self.seq_len
        r_begin = s_end - self.label_len
        r_end = r_begin  + self.label_len + self.pred_len 

        seq_x = self.data_x[s_begin:s_end]
        seq_y = self.data_y[r_begin:r_end]
        seq_x = torch.from_numpy(np.ascontiguousarray(seq_x)).type(torch.FloatTensor)
        seq_y = torch.from_numpy(np.ascontiguousarray(seq_y)).type(torch.FloatTensor)

        return  seq_y, seq_x

    def __len__(self):
        return len(self.data_x) - self.seq_len - self.pred_len + 1

    def inverse_transform(self, data):
        return self.scaler.inverse_transform(data)